/* SigmaStar trade secret */
/* Copyright (c) [2019~2020] SigmaStar Technology.
All rights reserved.

Unless otherwise stipulated in writing, any and all information contained
herein regardless in any format shall remain the sole proprietary of
SigmaStar and be kept in strict confidence
(SigmaStar Confidential Information) by the recipient.
Any unauthorized act including without limitation unauthorized disclosure,
copying, use, reproduction, sale, distribution, modification, disassembling,
reverse engineering and compiling of the contents of SigmaStar Confidential
Information is unlawful and strictly prohibited. SigmaStar hereby reserves the
rights to any and all damages, losses, costs and expenses resulting therefrom.
*/


///////////////////////////////////////////////////////////////////////////////
/// @file      cam_proc_wrapper.h
/// @brief     Cam PROC Wrapper Header File for
///            1. RTK OS
///            2. Linux Kernel Space
///////////////////////////////////////////////////////////////////////////////

#ifndef __CAM_PROC_WRAPPER_H__
#define __CAM_PROC_WRAPPER_H__

#if defined (__KERNEL__)
#include <linux/seq_file.h>
#endif

typedef     void                        CamProcDirEntry_t;

#ifdef CAM_OS_RTK
typedef     void                           CamProcSeqBuf_t;
#elif defined(__KERNEL__)
typedef     struct seq_file                CamProcSeqBuf_t;
#endif

typedef void (*CamProcCatCB)(CamProcSeqBuf_t *pProcBuf, int nLen);

typedef void (*CamProcEchoCB)(char *pProcBuf, int nLen);

#ifdef CAM_OS_RTK
#define CamProcPrintf(m, format, args...) CamOsPrintf(format, ##args)
#elif defined(__KERNEL__)
#define CamProcPrintf(m, format, args...) seq_printf(m, format, ##args)
#endif

//=============================================================================
// Description:
//      Create virtual directory entry
// Parameters:
//      [in]  name:          Pointer to a naming buffer with end character for this directory entry.
//      [in]  pParentEntry: Pointer to parent directory entry, it can be NULL when creating root entry
// Return:
//      Pointer to a directory entry handler
//=============================================================================
CamProcDirEntry_t* CamProcMkdir(const char *name, CamProcDirEntry_t *pParentEntry);

//=============================================================================
// Description:
//      Create sub-node under a specified directory entry
// Parameters:
//      [in]  name:          Pointer to a naming buffer with end character for this sub-node.
//      [in]  pParentEntry: Pointer to parent directory entry, it cannot be NULL.
//      [in]  pCatCB:         Pointer to callback function for cat command.
//      [in]  pEchoCB:         Pointer to callback function for echo command.
// Return:
//      Pointer to a sub-node handler
//=============================================================================
CamProcDirEntry_t* CamProcCreate(const char *name, u16 umode, \
                                CamProcDirEntry_t * pParentEntry,\
                                CamProcCatCB pCatCB, CamProcEchoCB pEchoCB);
//=============================================================================
// Description:
//      Remove directory entry/entries or node/nodes
// Parameters:
//      [in]  name:          Pointer to a naming buffer with end character for the entry/node.
//      [in]  pParentEntry: Pointer to parent directory entry, it can be NULL only when the entry it root entry
// Return:
//      N/A
//=============================================================================
void CamProcRemoveEntry(const char *name, CamProcDirEntry_t * pParentEntry);
#endif /* __CAM_PROC_WRAPPER_H__ */
